/* $Id: raw.c,v 1.3 1998/07/20 23:37:10 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Keith Bayern */

/***************************************************************************

This is a variation of minimum.c to demonstrate hpe1432_readRawData


***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "hpe1432.h"

#define BLOCK_SIZE 16

void main()
{
ViSession	session;
ViInt32		channels[10];
ViInt32		gid;
ViInt16	data[BLOCK_SIZE];
char		st[100];
ViInt32		actualCount;
ViInt32		i;
ViStatus	vierr;

    /* initialize instrument  This code ASSUMES hpe1432 at address 8 */
    vierr=hpe1432_init("VXI0::8::INSTR",0,1,&session);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);	    
        exit(0);
    }

    /* make an array of input channel numbers (only one in this simple demo) */
    channels[0]=1;

    vierr=hpe1432_createChannelGroup(session,1,channels,&gid);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* set the fifo blocksize */
    vierr=hpe1432_setBlocksize(session,gid,BLOCK_SIZE);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }


    vierr=hpe1432_setDataSize(session, gid, HPE1432_DATA_SIZE_16);
	if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }




    /* get some data coming */
    vierr=hpe1432_initMeasure(session,gid);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* wait for the data and then read it */
    vierr=hpe1432_readRawData(session,gid,
                                  HPE1432_TIME_DATA,
                                  (ViPChar)data,
                                  BLOCK_SIZE,
                                  &actualCount,
                                  HPE1432_WAIT_FLAG);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* print the data */
    for(i=0;i<5;i++)
		printf("%d\n",data[i]);


    
}





